/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.client.renderers.IItemRenderer;
import net.montoyo.wd.client.renderers.ModelMinePad;
import net.montoyo.wd.config.ClientConfig;
import net.montoyo.wd.item.ItemMinePad2;

@OnlyIn(value=Dist.CLIENT)
public final class MinePadRenderer
implements IItemRenderer {
    private static final float PI = (float)Math.PI;
    private final Minecraft mc = Minecraft.m_91087_();
    private final ResourceLocation tex = new ResourceLocation("webdisplays", "textures/models/minepad.png");
    private final ModelMinePad model = new ModelMinePad();
    private final ClientProxy clientProxy = (ClientProxy)WebDisplays.PROXY;
    private float sinSqrtSwingProg1;
    private float sinSqrtSwingProg2;
    private float sinSwingProg1;
    private float sinSwingProg2;

    public static boolean renderAtSide(float handSideSign) {
        boolean sideHold;
        float relSide = handSideSign;
        if (Minecraft.m_91087_().f_91074_.m_5737_() == HumanoidArm.LEFT) {
            relSide *= -1.0f;
        }
        boolean bl = sideHold = Minecraft.m_91087_().f_91074_.m_6144_() != ClientConfig.sidePad;
        if (relSide < 0.0f && Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ItemMinePad2 || relSide > 0.0f && Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ItemMinePad2) {
            sideHold = true;
        }
        return sideHold;
    }

    @Override
    public final boolean render(PoseStack stack, ItemStack is, float handSideSign, float swingProgress, float equipProgress, MultiBufferSource multiBufferSource, int packedLight) {
        ClientProxy.PadData pd;
        float sqrtSwingProg = (float)Math.sqrt(swingProgress);
        this.sinSqrtSwingProg1 = (float)Math.sin(sqrtSwingProg * (float)Math.PI);
        this.sinSqrtSwingProg2 = (float)Math.sin(sqrtSwingProg * (float)Math.PI * 2.0f);
        this.sinSwingProg1 = (float)Math.sin(swingProgress * (float)Math.PI);
        this.sinSwingProg2 = (float)Math.sin(swingProgress * swingProgress * (float)Math.PI);
        boolean sideHold = MinePadRenderer.renderAtSide(handSideSign);
        stack.m_85836_();
        this.renderArmFirstPerson(stack, multiBufferSource, packedLight, equipProgress, handSideSign);
        stack.m_85849_();
        stack.m_85836_();
        stack.m_85837_((double)(handSideSign * -0.4f * this.sinSqrtSwingProg1), (double)(0.2f * this.sinSqrtSwingProg2), (double)(-0.2f * this.sinSwingProg1));
        stack.m_85837_((double)(handSideSign * 0.56f), (double)(-0.52f - equipProgress * 0.6f), (double)-0.72f);
        stack.m_85845_(Vector3f.f_122225_.m_122240_(handSideSign * (45.0f - this.sinSwingProg2 * 20.0f)));
        stack.m_85845_(Vector3f.f_122227_.m_122240_(handSideSign * this.sinSqrtSwingProg1 * -20.0f));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(this.sinSqrtSwingProg1 * -80.0f));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(handSideSign * -45.0f));
        if (sideHold) {
            stack.m_85837_(0.0, 0.0, (double)-0.2f);
            stack.m_85845_(Vector3f.f_122225_.m_122240_(20.0f * -handSideSign));
            float total = 0.475f;
            float off = -0.025f;
            stack.m_85837_((double)(-(total - off) + off * handSideSign), (double)-0.1f, 0.0);
            stack.m_85845_(Vector3f.f_122227_.m_122240_(1.0f));
        } else if (handSideSign >= 0.0f) {
            stack.m_85837_((double)-1.065f, 0.0, 0.0);
        } else {
            stack.m_85837_((double)0.065f, 0.0, 0.0);
        }
        stack.m_85837_((double)0.063f, (double)0.28f, (double)0.001f);
        this.model.render(multiBufferSource, stack);
        stack.m_85837_((double)-0.063f, (double)-0.28f, (double)-0.001f);
        multiBufferSource.m_6299_((RenderType)RenderType.f_110371_);
        if (is.m_41783_() != null && is.m_41783_().m_128441_("PadID") && (pd = this.clientProxy.getPadByID(is.m_41783_().m_128342_("PadID"))) != null) {
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.8740625;
            double y2 = 0.4395;
            stack.m_85837_((double)0.063f, (double)0.28f, (double)0.001f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.tex);
            pd.view.draw(stack, x1, y1, x2, y2);
        }
        stack.m_85849_();
        RenderSystem.m_69481_();
        return true;
    }

    private void renderArmFirstPerson(PoseStack stack, MultiBufferSource buffer, int combinedLight, float equipProgress, float handSideSign) {
        float tx = -0.3f * this.sinSqrtSwingProg1;
        float ty = 0.4f * this.sinSqrtSwingProg2;
        float tz = -0.4f * this.sinSwingProg1;
        stack.m_85837_((double)(handSideSign * (tx + 0.64000005f)), (double)(ty - 0.6f - equipProgress * 0.6f), (double)(tz - 0.71999997f));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(handSideSign * 45.0f));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(handSideSign * this.sinSqrtSwingProg1 * 70.0f));
        stack.m_85845_(Vector3f.f_122227_.m_122240_(handSideSign * this.sinSwingProg2 * -20.0f));
        stack.m_85837_((double)(-handSideSign), (double)3.6f, 3.5);
        stack.m_85845_(Vector3f.f_122227_.m_122240_(handSideSign * 120.0f));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(200.0f));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(handSideSign * -135.0f));
        stack.m_85837_((double)(handSideSign * 5.6f), 0.0, 0.0);
        PlayerRenderer playerRenderer = (PlayerRenderer)this.mc.m_91290_().m_114382_((Entity)this.mc.f_91074_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.mc.f_91074_.m_108560_());
        if (handSideSign >= 0.0f) {
            playerRenderer.m_117770_(stack, buffer, combinedLight, (AbstractClientPlayer)this.mc.f_91074_);
        } else {
            playerRenderer.m_117813_(stack, buffer, combinedLight, (AbstractClientPlayer)this.mc.f_91074_);
        }
    }
}

